/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.melter.RecipeMelter;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class MelterRecipeCategory
implements IRecipeCategory<RecipeMelter> {
    private static final int FONT = 0x404040;
    static ResourceLocation ID = new ResourceLocation(CyclicRecipeType.MELTER.toString());
    private IDrawable gui;
    private IDrawable icon;

    public MelterRecipeCategory(IGuiHelper helper) {
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/melter_recipe.png"), 0, 0, 169, 69).setTextureSize(169, 69).build();
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)BlockRegistry.MELTER.get()));
    }

    public Component getTitle() {
        return UtilChat.ilang(((Block)BlockRegistry.MELTER.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public Class<? extends RecipeMelter> getRecipeClass() {
        return RecipeMelter.class;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public RecipeType getRecipeType() {
        return new RecipeType(this.getUid(), this.getRecipeClass());
    }

    public void setIngredients(RecipeMelter recipe, IIngredients ingredients) {
        ArrayList in = new ArrayList();
        ArrayList stuff = new ArrayList();
        Collections.addAll(stuff, recipe.ingredientAt(0));
        in.add(stuff);
        stuff = new ArrayList();
        Collections.addAll(stuff, recipe.ingredientAt(1));
        in.add(stuff);
        ingredients.setInputLists(VanillaTypes.ITEM, in);
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getRecipeFluid());
    }

    public void draw(RecipeMelter recipe, PoseStack ms, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getEnergy().getTicks() + " t", 60.0f, 0.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getEnergy().getRfPertick() + " RF/t", 60.0f, 10.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getEnergy().getEnergyTotal() + " RF", 60.0f, 20.0f, 0x404040);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipeMelter recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 3, 18);
        guiItemStacks.init(1, true, 21, 18);
        guiItemStacks.init(2, true, 41, 18);
        guiItemStacks.init(3, true, 3, 120);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List input = (List)inputs.get(0);
        if (input != null && !input.isEmpty()) {
            guiItemStacks.set(0, input);
        }
        if ((input = (List)inputs.get(1)) != null && !input.isEmpty()) {
            guiItemStacks.set(1, input);
        }
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getRecipeFluid());
        recipeLayout.getFluidStacks().init(0, true, 140, 19, 16, 16, 1000, false, null);
        recipeLayout.getFluidStacks().set(0, recipe.getRecipeFluid());
    }
}

